using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
class Program
{
    static void Main()
    {
        var reader = new Parser(); 
        var writer = new StreamWriter(Console.OpenStandardOutput(), new System.Text.UTF8Encoding(false), 65536);
        long n = reader.ReadLong(); 
        int k = reader.ReadInt();
        if (k == 0)
        {
            return;
        }
        long[] d = new long[k];
        for (int i = 0; i < k; i++)
        { d[i] = reader.ReadLong(); }

        long[] sortedD = new long[k];
        Array.Copy(d, sortedD, k);
        Array.Sort(sortedD);

        List<long> primes = new List<long>();
        foreach (var val in sortedD)
        {
            if (val <= 1)
            { continue; }
            bool isDivisible = false;
            foreach (var p in primes)
            {
                if (val % p == 0)
                {
                    isDivisible = true; break;
                }
            }
            if (!isDivisible)
            {
                primes.Add(val);
            }
        }
        long[] primesArray = primes.ToArray();
        long[] results = new long[k];
        Parallel.For(0, k, i => { results[i] = XorZbir(d[i], primesArray); });
        for (int i = 0; i < k; i++)
        { writer.Write(results[i]); if (i < k - 1) writer.Write(" "); }
        writer.WriteLine();
        writer.Flush();
    }
    static long XorZbir(long val, long[] primes)
    {
        if (val == 1)
        { return 1; }
        Span<long> localPrimes = stackalloc long[16];
        Span<int> exponents = stackalloc int[16];
        int count = 0;
        long temp = val;
        for (int j = 0; j < primes.Length; j++)
        {
            long p = primes[j];
            if (p * p > temp) { break; }

            if (temp % p == 0)
            {
                localPrimes[count] = p;
                int exp = 0;
                while (temp % p == 0)
                {
                    temp /= p;
                    exp++;
                }
                exponents[count] = exp;
                count++;
            }
        }
        if
        (temp > 1)
        {
            localPrimes[count] = temp;
            exponents[count] = 1;
            count++;
        }
        return DFS(0, 1, localPrimes.Slice(0,count), exponents.Slice(0, count));
    }
    static long DFS(int pIndex, long currentDivisor, ReadOnlySpan<long> localPrimes, ReadOnlySpan<int> exponents)
    {
        if (pIndex == localPrimes.Length)
        { return currentDivisor; }
        long totalXor = 0;
        long p = localPrimes[pIndex];
        int limit = exponents[pIndex];
        long pPow = 1;
        for (int e = 0; e <= limit; e++)
        {
            totalXor ^= DFS(pIndex + 1, currentDivisor * pPow, localPrimes, exponents);
            if (e < limit) { pPow *= p; }
        }
        return totalXor;
    }
}
class Parser
{
    private Queue<string> tokens = new Queue<string>();
    public string ReadToken()
    {
        while (tokens.Count == 0)
        {
            var line = Console.ReadLine();
            if (line == null)
            { return null; }
            if (string.IsNullOrWhiteSpace(line))
            { continue; }

            var parts = line.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            foreach (var p in parts)
            {
                tokens.Enqueue(p);
            }
        }
        return tokens.Dequeue();
    }
    public int ReadInt()
    {
        var t = ReadToken();
        return t == null?0:int.Parse(t);
    }
    public long ReadLong()
    {
        var t = ReadToken();
        return
            t == null ? 0 : long.Parse(t);
    }
}